const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_cubicle_bin_setting', {
    Sys_CubicNo: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    Sys_Area: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Sys_CubicleType: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Sys_CubicName: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Sys_IDS: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Sys_TotalBin: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Sys_TotalBinSelected: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Sys_BinID: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    Sys_Lot: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Sys_Printer: {
      type: DataTypes.STRING(500),
      allowNull: true
    },
    Sys_MfgDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Sys_ExpDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Sys_InitialStage: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Sys_NextStage: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Sys_LabelHeader: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Sys_BatchNo: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Sys_PrdID: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Sys_PrdName: {
      type: DataTypes.STRING(500),
      allowNull: true
    },
    Sys_PrdVersion: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Sys_Version: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Sys_DateNA: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    locked: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Sys_GenericName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Layer: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Sys_InstrumentID: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    TotalNetWeight: {
      type: DataTypes.STRING(50),
      allowNull: true
    }
  }, {
    sequelize,
    tableName: 'tbl_cubicle_bin_setting',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_cubi__09FFA2A82D10E459",
        unique: true,
        fields: [
          { name: "Sys_CubicNo" },
        ]
      },
    ]
  });
};
